package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  StatusReasonMessage,
  Arn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteGrantRequest(
    grantArn: Arn,
    statusReason: Option[StatusReasonMessage] = None,
    version: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest = {
    import DeleteGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest
      .builder()
      .grantArn(grantArn: java.lang.String)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .version(version: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.DeleteGrantRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.DeleteGrantRequest
      .wrap(buildAwsValue())
}
object DeleteGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.DeleteGrantRequest =
      io.github.vigoo.zioaws.licensemanager.model.DeleteGrantRequest(
        grantArnValue,
        statusReasonValue.map(value => value),
        versionValue
      )
    def grantArnValue: Arn
    def statusReasonValue: Option[StatusReasonMessage]
    def versionValue: String
    def grantArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(grantArnValue)
    def statusReason: ZIO[Any, AwsError, StatusReasonMessage] =
      AwsError.unwrapOptionField("statusReason", statusReasonValue)
    def version: ZIO[Any, Nothing, String] = ZIO.succeed(versionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.DeleteGrantRequest.ReadOnly {
    override def grantArnValue: Arn = impl.grantArn(): Arn
    override def statusReasonValue: Option[StatusReasonMessage] =
      scala.Option(impl.statusReason()).map(value => value: StatusReasonMessage)
    override def versionValue: String = impl.version(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest
  ): io.github.vigoo.zioaws.licensemanager.model.DeleteGrantRequest.ReadOnly =
    new Wrapper(impl)
}
