package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.ISO8601DateTime
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DatetimeRange(
    begin: ISO8601DateTime,
    end: Option[ISO8601DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.DatetimeRange = {
    import DatetimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DatetimeRange
      .builder()
      .begin(begin: java.lang.String)
      .optionallyWith(end.map(value => value: java.lang.String))(_.end)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.DatetimeRange
      .wrap(buildAwsValue())
}
object DatetimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.DatetimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.DatetimeRange =
      io.github.vigoo.zioaws.licensemanager.model
        .DatetimeRange(beginValue, endValue.map(value => value))
    def beginValue: ISO8601DateTime
    def endValue: Option[ISO8601DateTime]
    def begin: ZIO[Any, Nothing, ISO8601DateTime] = ZIO.succeed(beginValue)
    def end: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("end", endValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.DatetimeRange
  ) extends io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly {
    override def beginValue: ISO8601DateTime = impl.begin(): ISO8601DateTime
    override def endValue: Option[ISO8601DateTime] =
      scala.Option(impl.end()).map(value => value: ISO8601DateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.DatetimeRange
  ): io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly =
    new Wrapper(impl)
}
