package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  ClientToken,
  Integer,
  Arn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTokenRequest(
    licenseArn: Arn,
    roleArns: Option[Iterable[Arn]] = None,
    expirationInDays: Option[Integer] = None,
    tokenProperties: Option[Iterable[String]] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest = {
    import CreateTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest
      .builder()
      .licenseArn(licenseArn: java.lang.String)
      .optionallyWith(
        roleArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.roleArns)
      .optionallyWith(expirationInDays.map(value => value: java.lang.Integer))(
        _.expirationInDays
      )
      .optionallyWith(
        tokenProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tokenProperties)
      .clientToken(clientToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateTokenRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateTokenRequest
      .wrap(buildAwsValue())
}
object CreateTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateTokenRequest =
      io.github.vigoo.zioaws.licensemanager.model.CreateTokenRequest(
        licenseArnValue,
        roleArnsValue.map(value => value),
        expirationInDaysValue.map(value => value),
        tokenPropertiesValue.map(value => value),
        clientTokenValue
      )
    def licenseArnValue: Arn
    def roleArnsValue: Option[List[Arn]]
    def expirationInDaysValue: Option[Integer]
    def tokenPropertiesValue: Option[List[String]]
    def clientTokenValue: ClientToken
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def roleArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("roleArns", roleArnsValue)
    def expirationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("expirationInDays", expirationInDaysValue)
    def tokenProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tokenProperties", tokenPropertiesValue)
    def clientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateTokenRequest.ReadOnly {
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def roleArnsValue: Option[List[Arn]] = scala
      .Option(impl.roleArns())
      .map(value =>
        value.asScala.map { item =>
          item: Arn
        }.toList
      )
    override def expirationInDaysValue: Option[Integer] =
      scala.Option(impl.expirationInDays()).map(value => value: Integer)
    override def tokenPropertiesValue: Option[List[String]] = scala
      .Option(impl.tokenProperties())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def clientTokenValue: ClientToken = impl.clientToken(): ClientToken
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CreateTokenRequest.ReadOnly =
    new Wrapper(impl)
}
