package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseManagerReportGeneratorResponse(
    licenseManagerReportGeneratorArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse = {
    import CreateLicenseManagerReportGeneratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse
      .builder()
      .optionallyWith(
        licenseManagerReportGeneratorArn.map(value => value: java.lang.String)
      )(_.licenseManagerReportGeneratorArn)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse
      .wrap(buildAwsValue())
}
object CreateLicenseManagerReportGeneratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .CreateLicenseManagerReportGeneratorResponse(
          licenseManagerReportGeneratorArnValue.map(value => value)
        )
    def licenseManagerReportGeneratorArnValue: Option[String]
    def licenseManagerReportGeneratorArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseManagerReportGeneratorArn",
        licenseManagerReportGeneratorArnValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly {
    override def licenseManagerReportGeneratorArnValue: Option[String] = scala
      .Option(impl.licenseManagerReportGeneratorArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly =
    new Wrapper(impl)
}
