package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateLicenseConversionTaskForResourceRequest(
    resourceArn: Arn,
    sourceLicenseContext: io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext,
    destinationLicenseContext: io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest = {
    import CreateLicenseConversionTaskForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .sourceLicenseContext(sourceLicenseContext.buildAwsValue())
      .destinationLicenseContext(destinationLicenseContext.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceRequest
      .wrap(buildAwsValue())
}
object CreateLicenseConversionTaskForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .CreateLicenseConversionTaskForResourceRequest(
          resourceArnValue,
          sourceLicenseContextValue.editable,
          destinationLicenseContextValue.editable
        )
    def resourceArnValue: Arn
    def sourceLicenseContextValue
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    def destinationLicenseContextValue
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    def resourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArnValue)
    def sourceLicenseContext: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = ZIO.succeed(sourceLicenseContextValue)
    def destinationLicenseContext: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly
    ] = ZIO.succeed(destinationLicenseContextValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceRequest.ReadOnly {
    override def resourceArnValue: Arn = impl.resourceArn(): Arn
    override def sourceLicenseContextValue
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
        .wrap(impl.sourceLicenseContext())
    override def destinationLicenseContextValue
        : io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionContext
        .wrap(impl.destinationLicenseContext())
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
