package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxLong
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConsumedLicenseSummary(
    resourceType: Option[
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = None,
    consumedLicenses: Option[BoxLong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary = {
    import ConsumedLicenseSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(consumedLicenses.map(value => value: java.lang.Long))(
        _.consumedLicenses
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary
      .wrap(buildAwsValue())
}
object ConsumedLicenseSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary =
      io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary(
        resourceTypeValue.map(value => value),
        consumedLicensesValue.map(value => value)
      )
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType]
    def consumedLicensesValue: Option[BoxLong]
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def consumedLicenses: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("consumedLicenses", consumedLicensesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary
  ) extends io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary.ReadOnly {
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.ResourceType.wrap(value)
        )
    override def consumedLicensesValue: Option[BoxLong] =
      scala.Option(impl.consumedLicenses()).map(value => value: BoxLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary
  ): io.github.vigoo.zioaws.licensemanager.model.ConsumedLicenseSummary.ReadOnly =
    new Wrapper(impl)
}
