package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.DateTime
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AutomatedDiscoveryInformation(
    lastRunTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation = {
    import AutomatedDiscoveryInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation
      .builder()
      .optionallyWith(lastRunTime.map(value => value: Instant))(_.lastRunTime)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation
      .wrap(buildAwsValue())
}
object AutomatedDiscoveryInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation =
      io.github.vigoo.zioaws.licensemanager.model
        .AutomatedDiscoveryInformation(lastRunTimeValue.map(value => value))
    def lastRunTimeValue: Option[DateTime]
    def lastRunTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastRunTime", lastRunTimeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation
  ) extends io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation.ReadOnly {
    override def lastRunTimeValue: Option[DateTime] =
      scala.Option(impl.lastRunTime()).map(value => value: DateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.AutomatedDiscoveryInformation
  ): io.github.vigoo.zioaws.licensemanager.model.AutomatedDiscoveryInformation.ReadOnly =
    new Wrapper(impl)
}
