package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait AllowedOperation {
  def unwrap
      : software.amazon.awssdk.services.licensemanager.model.AllowedOperation
}
object AllowedOperation {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.AllowedOperation
  ): io.github.vigoo.zioaws.licensemanager.model.AllowedOperation =
    value match {
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CREATE_GRANT =>
        val r = CreateGrant
        r
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CHECKOUT_LICENSE =>
        val r = CheckoutLicense
        r
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CHECKOUT_BORROW_LICENSE =>
        val r = CheckoutBorrowLicense
        r
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CHECK_IN_LICENSE =>
        val r = CheckInLicense
        r
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.EXTEND_CONSUMPTION_LICENSE =>
        val r = ExtendConsumptionLicense
        r
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.LIST_PURCHASED_LICENSES =>
        val r = ListPurchasedLicenses
        r
      case software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CREATE_TOKEN =>
        val r = CreateToken
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.UNKNOWN_TO_SDK_VERSION
  }
  case object CreateGrant
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CREATE_GRANT
  }
  case object CheckoutLicense
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CHECKOUT_LICENSE
  }
  case object CheckoutBorrowLicense
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CHECKOUT_BORROW_LICENSE
  }
  case object CheckInLicense
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CHECK_IN_LICENSE
  }
  case object ExtendConsumptionLicense
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.EXTEND_CONSUMPTION_LICENSE
  }
  case object ListPurchasedLicenses
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.LIST_PURCHASED_LICENSES
  }
  case object CreateToken
      extends io.github.vigoo.zioaws.licensemanager.model.AllowedOperation {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.AllowedOperation =
      software.amazon.awssdk.services.licensemanager.model.AllowedOperation.CREATE_TOKEN
  }
}
