package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateLicenseSpecificationsForResourceRequest(
    resourceArn: String,
    addLicenseSpecifications: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification]
    ] = None,
    removeLicenseSpecifications: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest = {
    import UpdateLicenseSpecificationsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(
        addLicenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addLicenseSpecifications)
      .optionallyWith(
        removeLicenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeLicenseSpecifications)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest
      .wrap(buildAwsValue())
}
object UpdateLicenseSpecificationsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .UpdateLicenseSpecificationsForResourceRequest(
          resourceArnValue,
          addLicenseSpecificationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          removeLicenseSpecificationsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def resourceArnValue: String
    def addLicenseSpecificationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]]
    def removeLicenseSpecificationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def addLicenseSpecifications: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "addLicenseSpecifications",
      addLicenseSpecificationsValue
    )
    def removeLicenseSpecifications: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "removeLicenseSpecifications",
      removeLicenseSpecificationsValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def addLicenseSpecificationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]] = scala
      .Option(impl.addLicenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification
            .wrap(item)
        }.toList
      )
    override def removeLicenseSpecificationsValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ]] = scala
      .Option(impl.removeLicenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest
  ): io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
