package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: String,
    tags: Iterable[io.github.vigoo.zioaws.licensemanager.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.TagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.TagResourceRequest =
      io.github.vigoo.zioaws.licensemanager.model.TagResourceRequest(
        resourceArnValue,
        tagsValue.map { item =>
          item.editable
        }
      )
    def resourceArnValue: String
    def tagsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def tags: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly
    ]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.TagResourceRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.TagResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def tagsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.licensemanager.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.TagResourceRequest
  ): io.github.vigoo.zioaws.licensemanager.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
