package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReportFrequency(
    value: Option[Integer] = None,
    period: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ReportFrequency = {
    import ReportFrequency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReportFrequency
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Integer))(_.value)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ReportFrequency
      .wrap(buildAwsValue())
}
object ReportFrequency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ReportFrequency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.ReportFrequency =
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequency(
        valueValue.map(value => value),
        periodValue.map(value => value)
      )
    def valueValue: Option[Integer]
    def periodValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType
    ]
    def value: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("value", valueValue)
    def period: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType
    ] = AwsError.unwrapOptionField("period", periodValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ReportFrequency
  ) extends io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly {
    override def valueValue: Option[Integer] =
      scala.Option(impl.value()).map(value => value: Integer)
    override def periodValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType
    ] = scala
      .Option(impl.period())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ReportFrequency
  ): io.github.vigoo.zioaws.licensemanager.model.ReportFrequency.ReadOnly =
    new Wrapper(impl)
}
