package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListUsageForLicenseConfigurationResponse(
    licenseConfigurationUsageList: Option[Iterable[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage
    ]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse = {
    import ListUsageForLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse
      .builder()
      .optionallyWith(
        licenseConfigurationUsageList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseConfigurationUsageList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationResponse
      .wrap(buildAwsValue())
}
object ListUsageForLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ListUsageForLicenseConfigurationResponse(
          licenseConfigurationUsageListValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def licenseConfigurationUsageListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
    ]]
    def nextTokenValue: Option[String]
    def licenseConfigurationUsageList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseConfigurationUsageList",
      licenseConfigurationUsageListValue
    )
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationResponse.ReadOnly {
    override def licenseConfigurationUsageListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
    ]] = scala
      .Option(impl.licenseConfigurationUsageList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListUsageForLicenseConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
