package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTokensResponse(
    tokens: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.TokenData]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListTokensResponse = {
    import ListTokensResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListTokensResponse
      .builder()
      .optionallyWith(
        tokens.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tokens)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListTokensResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListTokensResponse
      .wrap(buildAwsValue())
}
object ListTokensResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListTokensResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListTokensResponse =
      io.github.vigoo.zioaws.licensemanager.model.ListTokensResponse(
        tokensValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def tokensValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly]
    ]
    def nextTokenValue: Option[String]
    def tokens: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly
    ]] = AwsError.unwrapOptionField("tokens", tokensValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListTokensResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListTokensResponse.ReadOnly {
    override def tokensValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly]
    ] = scala
      .Option(impl.tokens())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.TokenData.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListTokensResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ListTokensResponse.ReadOnly =
    new Wrapper(impl)
}
