package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LicenseSpecification(
    licenseConfigurationArn: String,
    amiAssociationScope: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.LicenseSpecification = {
    import LicenseSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseSpecification
      .builder()
      .licenseConfigurationArn(licenseConfigurationArn: java.lang.String)
      .optionallyWith(
        amiAssociationScope.map(value => value: java.lang.String)
      )(_.amiAssociationScope)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification
      .wrap(buildAwsValue())
}
object LicenseSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.LicenseSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification =
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification(
        licenseConfigurationArnValue,
        amiAssociationScopeValue.map(value => value)
      )
    def licenseConfigurationArnValue: String
    def amiAssociationScopeValue: Option[String]
    def licenseConfigurationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseConfigurationArnValue)
    def amiAssociationScope: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("amiAssociationScope", amiAssociationScopeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseSpecification
  ) extends io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly {
    override def licenseConfigurationArnValue: String =
      impl.licenseConfigurationArn(): String
    override def amiAssociationScopeValue: Option[String] =
      scala.Option(impl.amiAssociationScope()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.LicenseSpecification
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly =
    new Wrapper(impl)
}
