package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait LicenseConversionTaskStatus {
  def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus
}
object LicenseConversionTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus
  ): io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus =
    value match {
      case software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.IN_PROGRESS =>
        val r = IN_PROGRESS
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.SUCCEEDED =>
        val r = SUCCEEDED
        r
      case software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.FAILED =>
        val r = FAILED
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus =
      software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus =
      software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.IN_PROGRESS
  }
  case object SUCCEEDED
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus =
      software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.SUCCEEDED
  }
  case object FAILED
      extends io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus =
      software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus.FAILED
  }
}
