package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  ISO8601DateTime,
  Arn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class License(
    licenseArn: Option[Arn] = None,
    licenseName: Option[String] = None,
    productName: Option[String] = None,
    productSKU: Option[String] = None,
    issuer: Option[io.github.vigoo.zioaws.licensemanager.model.IssuerDetails] =
      None,
    homeRegion: Option[String] = None,
    status: Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus] =
      None,
    validity: Option[
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange
    ] = None,
    beneficiary: Option[String] = None,
    entitlements: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Entitlement]
    ] = None,
    consumptionConfiguration: Option[
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration
    ] = None,
    licenseMetadata: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Metadata]
    ] = None,
    createTime: Option[ISO8601DateTime] = None,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.License = {
    import License.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.License
      .builder()
      .optionallyWith(licenseArn.map(value => value: java.lang.String))(
        _.licenseArn
      )
      .optionallyWith(licenseName.map(value => value: java.lang.String))(
        _.licenseName
      )
      .optionallyWith(productName.map(value => value: java.lang.String))(
        _.productName
      )
      .optionallyWith(productSKU.map(value => value: java.lang.String))(
        _.productSKU
      )
      .optionallyWith(issuer.map(value => value.buildAwsValue()))(_.issuer)
      .optionallyWith(homeRegion.map(value => value: java.lang.String))(
        _.homeRegion
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(validity.map(value => value.buildAwsValue()))(_.validity)
      .optionallyWith(beneficiary.map(value => value: java.lang.String))(
        _.beneficiary
      )
      .optionallyWith(
        entitlements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitlements)
      .optionallyWith(
        consumptionConfiguration.map(value => value.buildAwsValue())
      )(_.consumptionConfiguration)
      .optionallyWith(
        licenseMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseMetadata)
      .optionallyWith(createTime.map(value => value: java.lang.String))(
        _.createTime
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.License.wrap(buildAwsValue())
}
object License {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.License
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.License =
      io.github.vigoo.zioaws.licensemanager.model.License(
        licenseArnValue.map(value => value),
        licenseNameValue.map(value => value),
        productNameValue.map(value => value),
        productSKUValue.map(value => value),
        issuerValue.map(value => value.editable),
        homeRegionValue.map(value => value),
        statusValue.map(value => value),
        validityValue.map(value => value.editable),
        beneficiaryValue.map(value => value),
        entitlementsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        consumptionConfigurationValue.map(value => value.editable),
        licenseMetadataValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        createTimeValue.map(value => value),
        versionValue.map(value => value)
      )
    def licenseArnValue: Option[Arn]
    def licenseNameValue: Option[String]
    def productNameValue: Option[String]
    def productSKUValue: Option[String]
    def issuerValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.IssuerDetails.ReadOnly
    ]
    def homeRegionValue: Option[String]
    def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus]
    def validityValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly
    ]
    def beneficiaryValue: Option[String]
    def entitlementsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly]
    ]
    def consumptionConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly
    ]
    def licenseMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ]
    def createTimeValue: Option[ISO8601DateTime]
    def versionValue: Option[String]
    def licenseArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def licenseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseName", licenseNameValue)
    def productName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productName", productNameValue)
    def productSKU: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productSKU", productSKUValue)
    def issuer: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.IssuerDetails.ReadOnly
    ] = AwsError.unwrapOptionField("issuer", issuerValue)
    def homeRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("homeRegion", homeRegionValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def validity: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("validity", validityValue)
    def beneficiary: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("beneficiary", beneficiaryValue)
    def entitlements: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly
    ]] = AwsError.unwrapOptionField("entitlements", entitlementsValue)
    def consumptionConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "consumptionConfiguration",
      consumptionConfigurationValue
    )
    def licenseMetadata: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly
    ]] = AwsError.unwrapOptionField("licenseMetadata", licenseMetadataValue)
    def createTime: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("createTime", createTimeValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.License
  ) extends io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly {
    override def licenseArnValue: Option[Arn] =
      scala.Option(impl.licenseArn()).map(value => value: Arn)
    override def licenseNameValue: Option[String] =
      scala.Option(impl.licenseName()).map(value => value: String)
    override def productNameValue: Option[String] =
      scala.Option(impl.productName()).map(value => value: String)
    override def productSKUValue: Option[String] =
      scala.Option(impl.productSKU()).map(value => value: String)
    override def issuerValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.IssuerDetails.ReadOnly
    ] = scala
      .Option(impl.issuer())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.IssuerDetails.wrap(value)
      )
    override def homeRegionValue: Option[String] =
      scala.Option(impl.homeRegion()).map(value => value: String)
    override def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.LicenseStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.LicenseStatus.wrap(value)
        )
    override def validityValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly
    ] = scala
      .Option(impl.validity())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.wrap(value)
      )
    override def beneficiaryValue: Option[String] =
      scala.Option(impl.beneficiary()).map(value => value: String)
    override def entitlementsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly]
    ] = scala
      .Option(impl.entitlements())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Entitlement.wrap(item)
        }.toList
      )
    override def consumptionConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.consumptionConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration
          .wrap(value)
      )
    override def licenseMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ] = scala
      .Option(impl.licenseMetadata())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Metadata.wrap(item)
        }.toList
      )
    override def createTimeValue: Option[ISO8601DateTime] =
      scala.Option(impl.createTime()).map(value => value: ISO8601DateTime)
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.License
  ): io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly = new Wrapper(
    impl
  )
}
