package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Issuer(name: String, signKey: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.Issuer = {
    import Issuer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Issuer
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(signKey.map(value => value: java.lang.String))(_.signKey)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.Issuer.wrap(buildAwsValue())
}
object Issuer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.Issuer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.Issuer =
      io.github.vigoo.zioaws.licensemanager.model
        .Issuer(nameValue, signKeyValue.map(value => value))
    def nameValue: String
    def signKeyValue: Option[String]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def signKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signKey", signKeyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.Issuer
  ) extends io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def signKeyValue: Option[String] =
      scala.Option(impl.signKey()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.Issuer
  ): io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly = new Wrapper(
    impl
  )
}
