package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.ISO8601DateTime
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExtendLicenseConsumptionResponse(
    licenseConsumptionToken: Option[String] = None,
    expiration: Option[ISO8601DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse = {
    import ExtendLicenseConsumptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse
      .builder()
      .optionallyWith(
        licenseConsumptionToken.map(value => value: java.lang.String)
      )(_.licenseConsumptionToken)
      .optionallyWith(expiration.map(value => value: java.lang.String))(
        _.expiration
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse
      .wrap(buildAwsValue())
}
object ExtendLicenseConsumptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .ExtendLicenseConsumptionResponse(
          licenseConsumptionTokenValue.map(value => value),
          expirationValue.map(value => value)
        )
    def licenseConsumptionTokenValue: Option[String]
    def expirationValue: Option[ISO8601DateTime]
    def licenseConsumptionToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseConsumptionToken",
        licenseConsumptionTokenValue
      )
    def expiration: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("expiration", expirationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly {
    override def licenseConsumptionTokenValue: Option[String] =
      scala.Option(impl.licenseConsumptionToken()).map(value => value: String)
    override def expirationValue: Option[ISO8601DateTime] =
      scala.Option(impl.expiration()).map(value => value: ISO8601DateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse
  ): io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly =
    new Wrapper(impl)
}
