package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.ISO8601DateTime
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteLicenseResponse(
    status: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseDeletionStatus
    ] = None,
    deletionDate: Option[ISO8601DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse = {
    import DeleteLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(deletionDate.map(value => value: java.lang.String))(
        _.deletionDate
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse
      .wrap(buildAwsValue())
}
object DeleteLicenseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse =
      io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse(
        statusValue.map(value => value),
        deletionDateValue.map(value => value)
      )
    def statusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseDeletionStatus
    ]
    def deletionDateValue: Option[ISO8601DateTime]
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseDeletionStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def deletionDate: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("deletionDate", deletionDateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse.ReadOnly {
    override def statusValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.LicenseDeletionStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseDeletionStatus
          .wrap(value)
      )
    override def deletionDateValue: Option[ISO8601DateTime] =
      scala.Option(impl.deletionDate()).map(value => value: ISO8601DateTime)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse
  ): io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse.ReadOnly =
    new Wrapper(impl)
}
