package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConsumptionConfiguration(
    renewType: Option[io.github.vigoo.zioaws.licensemanager.model.RenewType] =
      None,
    provisionalConfiguration: Option[
      io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration
    ] = None,
    borrowConfiguration: Option[
      io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration = {
    import ConsumptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration
      .builder()
      .optionallyWith(renewType.map(value => value.unwrap))(_.renewType)
      .optionallyWith(
        provisionalConfiguration.map(value => value.buildAwsValue())
      )(_.provisionalConfiguration)
      .optionallyWith(borrowConfiguration.map(value => value.buildAwsValue()))(
        _.borrowConfiguration
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration
      .wrap(buildAwsValue())
}
object ConsumptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration =
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration(
        renewTypeValue.map(value => value),
        provisionalConfigurationValue.map(value => value.editable),
        borrowConfigurationValue.map(value => value.editable)
      )
    def renewTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.RenewType]
    def provisionalConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration.ReadOnly
    ]
    def borrowConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration.ReadOnly
    ]
    def renewType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.RenewType
    ] = AwsError.unwrapOptionField("renewType", renewTypeValue)
    def provisionalConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionalConfiguration",
      provisionalConfigurationValue
    )
    def borrowConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "borrowConfiguration",
      borrowConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration
  ) extends io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly {
    override def renewTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.RenewType] = scala
      .Option(impl.renewType())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.RenewType.wrap(value)
      )
    override def provisionalConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration.ReadOnly
    ] = scala
      .Option(impl.provisionalConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.ProvisionalConfiguration
          .wrap(value)
      )
    override def borrowConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration.ReadOnly
    ] = scala
      .Option(impl.borrowConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.BorrowConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration
  ): io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
