package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  ISO8601DateTime,
  SignedToken
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CheckoutLicenseResponse(
    checkoutType: Option[
      io.github.vigoo.zioaws.licensemanager.model.CheckoutType
    ] = None,
    licenseConsumptionToken: Option[String] = None,
    entitlementsAllowed: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.EntitlementData]
    ] = None,
    signedToken: Option[SignedToken] = None,
    nodeId: Option[String] = None,
    issuedAt: Option[ISO8601DateTime] = None,
    expiration: Option[ISO8601DateTime] = None,
    licenseArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse = {
    import CheckoutLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse
      .builder()
      .optionallyWith(checkoutType.map(value => value.unwrap))(_.checkoutType)
      .optionallyWith(
        licenseConsumptionToken.map(value => value: java.lang.String)
      )(_.licenseConsumptionToken)
      .optionallyWith(
        entitlementsAllowed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitlementsAllowed)
      .optionallyWith(signedToken.map(value => value: java.lang.String))(
        _.signedToken
      )
      .optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId)
      .optionallyWith(issuedAt.map(value => value: java.lang.String))(
        _.issuedAt
      )
      .optionallyWith(expiration.map(value => value: java.lang.String))(
        _.expiration
      )
      .optionallyWith(licenseArn.map(value => value: java.lang.String))(
        _.licenseArn
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse
      .wrap(buildAwsValue())
}
object CheckoutLicenseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse =
      io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse(
        checkoutTypeValue.map(value => value),
        licenseConsumptionTokenValue.map(value => value),
        entitlementsAllowedValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        signedTokenValue.map(value => value),
        nodeIdValue.map(value => value),
        issuedAtValue.map(value => value),
        expirationValue.map(value => value),
        licenseArnValue.map(value => value)
      )
    def checkoutTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.CheckoutType]
    def licenseConsumptionTokenValue: Option[String]
    def entitlementsAllowedValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly]
    ]
    def signedTokenValue: Option[SignedToken]
    def nodeIdValue: Option[String]
    def issuedAtValue: Option[ISO8601DateTime]
    def expirationValue: Option[ISO8601DateTime]
    def licenseArnValue: Option[String]
    def checkoutType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CheckoutType
    ] = AwsError.unwrapOptionField("checkoutType", checkoutTypeValue)
    def licenseConsumptionToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseConsumptionToken",
        licenseConsumptionTokenValue
      )
    def entitlementsAllowed: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "entitlementsAllowed",
      entitlementsAllowedValue
    )
    def signedToken: ZIO[Any, AwsError, SignedToken] =
      AwsError.unwrapOptionField("signedToken", signedTokenValue)
    def nodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeId", nodeIdValue)
    def issuedAt: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def expiration: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("expiration", expirationValue)
    def licenseArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseArn", licenseArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly {
    override def checkoutTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.CheckoutType] =
      scala
        .Option(impl.checkoutType())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.CheckoutType.wrap(value)
        )
    override def licenseConsumptionTokenValue: Option[String] =
      scala.Option(impl.licenseConsumptionToken()).map(value => value: String)
    override def entitlementsAllowedValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly]
    ] = scala
      .Option(impl.entitlementsAllowed())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.EntitlementData.wrap(item)
        }.toList
      )
    override def signedTokenValue: Option[SignedToken] =
      scala.Option(impl.signedToken()).map(value => value: SignedToken)
    override def nodeIdValue: Option[String] =
      scala.Option(impl.nodeId()).map(value => value: String)
    override def issuedAtValue: Option[ISO8601DateTime] =
      scala.Option(impl.issuedAt()).map(value => value: ISO8601DateTime)
    override def expirationValue: Option[ISO8601DateTime] =
      scala.Option(impl.expiration()).map(value => value: ISO8601DateTime)
    override def licenseArnValue: Option[String] =
      scala.Option(impl.licenseArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly =
    new Wrapper(impl)
}
