package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CheckInLicenseRequest(
    licenseConsumptionToken: String,
    beneficiary: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest = {
    import CheckInLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest
      .builder()
      .licenseConsumptionToken(licenseConsumptionToken: java.lang.String)
      .optionallyWith(beneficiary.map(value => value: java.lang.String))(
        _.beneficiary
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseRequest
      .wrap(buildAwsValue())
}
object CheckInLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseRequest =
      io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseRequest(
        licenseConsumptionTokenValue,
        beneficiaryValue.map(value => value)
      )
    def licenseConsumptionTokenValue: String
    def beneficiaryValue: Option[String]
    def licenseConsumptionToken: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseConsumptionTokenValue)
    def beneficiary: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("beneficiary", beneficiaryValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseRequest.ReadOnly {
    override def licenseConsumptionTokenValue: String =
      impl.licenseConsumptionToken(): String
    override def beneficiaryValue: Option[String] =
      scala.Option(impl.beneficiary()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseRequest.ReadOnly =
    new Wrapper(impl)
}
