package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxBoolean
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateServiceSettingsRequest(
    s3BucketArn: Option[String] = None,
    snsTopicArn: Option[String] = None,
    organizationConfiguration: Option[
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration
    ] = None,
    enableCrossAccountsDiscovery: Option[BoxBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest = {
    import UpdateServiceSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest
      .builder()
      .optionallyWith(s3BucketArn.map(value => value: java.lang.String))(
        _.s3BucketArn
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(
        organizationConfiguration.map(value => value.buildAwsValue())
      )(_.organizationConfiguration)
      .optionallyWith(
        enableCrossAccountsDiscovery.map(value => value: java.lang.Boolean)
      )(_.enableCrossAccountsDiscovery)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateServiceSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsRequest =
      io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsRequest(
        s3BucketArnValue.map(value => value),
        snsTopicArnValue.map(value => value),
        organizationConfigurationValue.map(value => value.editable),
        enableCrossAccountsDiscoveryValue.map(value => value)
      )
    def s3BucketArnValue: Option[String]
    def snsTopicArnValue: Option[String]
    def organizationConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration.ReadOnly
    ]
    def enableCrossAccountsDiscoveryValue: Option[BoxBoolean]
    def s3BucketArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArnValue)
    def snsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def organizationConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationConfiguration",
      organizationConfigurationValue
    )
    def enableCrossAccountsDiscovery: ZIO[Any, AwsError, BoxBoolean] =
      AwsError.unwrapOptionField(
        "enableCrossAccountsDiscovery",
        enableCrossAccountsDiscoveryValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsRequest.ReadOnly {
    override def s3BucketArnValue: Option[String] =
      scala.Option(impl.s3BucketArn()).map(value => value: String)
    override def snsTopicArnValue: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def organizationConfigurationValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration.ReadOnly
    ] = scala
      .Option(impl.organizationConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.OrganizationConfiguration
          .wrap(value)
      )
    override def enableCrossAccountsDiscoveryValue: Option[BoxBoolean] = scala
      .Option(impl.enableCrossAccountsDiscovery())
      .map(value => value: BoxBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest
  ): io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
