package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait ReportFrequencyType {
  def unwrap
      : software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType
}
object ReportFrequencyType {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType
  ): io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType =
    value match {
      case software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.DAY =>
        val r = DAY
        r
      case software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.WEEK =>
        val r = WEEK
        r
      case software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.MONTH =>
        val r = MONTH
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType =
      software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.UNKNOWN_TO_SDK_VERSION
  }
  case object DAY
      extends io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType =
      software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.DAY
  }
  case object WEEK
      extends io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType =
      software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.WEEK
  }
  case object MONTH
      extends io.github.vigoo.zioaws.licensemanager.model.ReportFrequencyType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType =
      software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType.MONTH
  }
}
