package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxInteger
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListResourceInventoryRequest(
    maxResults: Option[BoxInteger] = None,
    nextToken: Option[String] = None,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.InventoryFilter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest = {
    import ListResourceInventoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryRequest
      .wrap(buildAwsValue())
}
object ListResourceInventoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryRequest =
      io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryRequest(
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value),
        filtersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def maxResultsValue: Option[BoxInteger]
    def nextTokenValue: Option[String]
    def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.InventoryFilter.ReadOnly]
    ]
    def maxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.InventoryFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryRequest.ReadOnly {
    override def maxResultsValue: Option[BoxInteger] =
      scala.Option(impl.maxResults()).map(value => value: BoxInteger)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.InventoryFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.InventoryFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ListResourceInventoryRequest.ReadOnly =
    new Wrapper(impl)
}
