package io.github.vigoo.zioaws.licensemanager.model
import java.lang.Integer
import io.github.vigoo.zioaws.licensemanager.model.primitives.{MaxSize100, Arn}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListReceivedGrantsRequest(
    grantArns: Option[Iterable[Arn]] = None,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Filter]
    ] = None,
    nextToken: Option[String] = None,
    maxResults: Option[MaxSize100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest = {
    import ListReceivedGrantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest
      .builder()
      .optionallyWith(
        grantArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.grantArns)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.ListReceivedGrantsRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.ListReceivedGrantsRequest
      .wrap(buildAwsValue())
}
object ListReceivedGrantsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.ListReceivedGrantsRequest =
      io.github.vigoo.zioaws.licensemanager.model.ListReceivedGrantsRequest(
        grantArnsValue.map(value => value),
        filtersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def grantArnsValue: Option[List[Arn]]
    def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ]
    def nextTokenValue: Option[String]
    def maxResultsValue: Option[MaxSize100]
    def grantArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("grantArns", grantArnsValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxSize100] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.ListReceivedGrantsRequest.ReadOnly {
    override def grantArnsValue: Option[List[Arn]] = scala
      .Option(impl.grantArns())
      .map(value =>
        value.asScala.map { item =>
          item: Arn
        }.toList
      )
    override def filtersValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Filter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Filter.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: Option[MaxSize100] =
      scala.Option(impl.maxResults()).map(value => value: MaxSize100)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest
  ): io.github.vigoo.zioaws.licensemanager.model.ListReceivedGrantsRequest.ReadOnly =
    new Wrapper(impl)
}
