package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IssuerDetails(
    name: Option[String] = None,
    signKey: Option[String] = None,
    keyFingerprint: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.IssuerDetails = {
    import IssuerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.IssuerDetails
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(signKey.map(value => value: java.lang.String))(_.signKey)
      .optionallyWith(keyFingerprint.map(value => value: java.lang.String))(
        _.keyFingerprint
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.IssuerDetails.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.IssuerDetails
      .wrap(buildAwsValue())
}
object IssuerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.IssuerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.IssuerDetails =
      io.github.vigoo.zioaws.licensemanager.model.IssuerDetails(
        nameValue.map(value => value),
        signKeyValue.map(value => value),
        keyFingerprintValue.map(value => value)
      )
    def nameValue: Option[String]
    def signKeyValue: Option[String]
    def keyFingerprintValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def signKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signKey", signKeyValue)
    def keyFingerprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyFingerprint", keyFingerprintValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.IssuerDetails
  ) extends io.github.vigoo.zioaws.licensemanager.model.IssuerDetails.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def signKeyValue: Option[String] =
      scala.Option(impl.signKey()).map(value => value: String)
    override def keyFingerprintValue: Option[String] =
      scala.Option(impl.keyFingerprint()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.IssuerDetails
  ): io.github.vigoo.zioaws.licensemanager.model.IssuerDetails.ReadOnly =
    new Wrapper(impl)
}
