package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InventoryFilter(
    name: String,
    condition: io.github.vigoo.zioaws.licensemanager.model.InventoryFilterCondition,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.InventoryFilter = {
    import InventoryFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.InventoryFilter
      .builder()
      .name(name: java.lang.String)
      .condition(condition.unwrap)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.InventoryFilter.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.InventoryFilter
      .wrap(buildAwsValue())
}
object InventoryFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.InventoryFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.InventoryFilter =
      io.github.vigoo.zioaws.licensemanager.model.InventoryFilter(
        nameValue,
        conditionValue,
        valueValue.map(value => value)
      )
    def nameValue: String
    def conditionValue
        : io.github.vigoo.zioaws.licensemanager.model.InventoryFilterCondition
    def valueValue: Option[String]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def condition: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.InventoryFilterCondition
    ] = ZIO.succeed(conditionValue)
    def value: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.InventoryFilter
  ) extends io.github.vigoo.zioaws.licensemanager.model.InventoryFilter.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def conditionValue
        : io.github.vigoo.zioaws.licensemanager.model.InventoryFilterCondition =
      io.github.vigoo.zioaws.licensemanager.model.InventoryFilterCondition
        .wrap(impl.condition())
    override def valueValue: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.InventoryFilter
  ): io.github.vigoo.zioaws.licensemanager.model.InventoryFilter.ReadOnly =
    new Wrapper(impl)
}
