package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  StatusReasonMessage,
  Arn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Grant(
    grantArn: Arn,
    grantName: String,
    parentArn: Arn,
    licenseArn: Arn,
    granteePrincipalArn: Arn,
    homeRegion: String,
    grantStatus: io.github.vigoo.zioaws.licensemanager.model.GrantStatus,
    statusReason: Option[StatusReasonMessage] = None,
    version: String,
    grantedOperations: Iterable[
      io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.Grant = {
    import Grant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Grant
      .builder()
      .grantArn(grantArn: java.lang.String)
      .grantName(grantName: java.lang.String)
      .parentArn(parentArn: java.lang.String)
      .licenseArn(licenseArn: java.lang.String)
      .granteePrincipalArn(granteePrincipalArn: java.lang.String)
      .homeRegion(homeRegion: java.lang.String)
      .grantStatus(grantStatus.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .version(version: java.lang.String)
      .grantedOperationsWithStrings(grantedOperations.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.Grant.wrap(buildAwsValue())
}
object Grant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.Grant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.Grant =
      io.github.vigoo.zioaws.licensemanager.model.Grant(
        grantArnValue,
        grantNameValue,
        parentArnValue,
        licenseArnValue,
        granteePrincipalArnValue,
        homeRegionValue,
        grantStatusValue,
        statusReasonValue.map(value => value),
        versionValue,
        grantedOperationsValue
      )
    def grantArnValue: Arn
    def grantNameValue: String
    def parentArnValue: Arn
    def licenseArnValue: Arn
    def granteePrincipalArnValue: Arn
    def homeRegionValue: String
    def grantStatusValue
        : io.github.vigoo.zioaws.licensemanager.model.GrantStatus
    def statusReasonValue: Option[StatusReasonMessage]
    def versionValue: String
    def grantedOperationsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    def grantArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(grantArnValue)
    def grantName: ZIO[Any, Nothing, String] = ZIO.succeed(grantNameValue)
    def parentArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(parentArnValue)
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def granteePrincipalArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(granteePrincipalArnValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def grantStatus: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.GrantStatus
    ] = ZIO.succeed(grantStatusValue)
    def statusReason: ZIO[Any, AwsError, StatusReasonMessage] =
      AwsError.unwrapOptionField("statusReason", statusReasonValue)
    def version: ZIO[Any, Nothing, String] = ZIO.succeed(versionValue)
    def grantedOperations: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
    ]] = ZIO.succeed(grantedOperationsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.Grant
  ) extends io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly {
    override def grantArnValue: Arn = impl.grantArn(): Arn
    override def grantNameValue: String = impl.grantName(): String
    override def parentArnValue: Arn = impl.parentArn(): Arn
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def granteePrincipalArnValue: Arn = impl.granteePrincipalArn(): Arn
    override def homeRegionValue: String = impl.homeRegion(): String
    override def grantStatusValue
        : io.github.vigoo.zioaws.licensemanager.model.GrantStatus =
      io.github.vigoo.zioaws.licensemanager.model.GrantStatus
        .wrap(impl.grantStatus())
    override def statusReasonValue: Option[StatusReasonMessage] =
      scala.Option(impl.statusReason()).map(value => value: StatusReasonMessage)
    override def versionValue: String = impl.version(): String
    override def grantedOperationsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation] =
      impl
        .grantedOperations()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
            .wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.Grant
  ): io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly = new Wrapper(
    impl
  )
}
