package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLicenseRequest(
    licenseArn: Arn,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest = {
    import GetLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest
      .builder()
      .licenseArn(licenseArn: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetLicenseRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseRequest
      .wrap(buildAwsValue())
}
object GetLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetLicenseRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .GetLicenseRequest(licenseArnValue, versionValue.map(value => value))
    def licenseArnValue: Arn
    def versionValue: Option[String]
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetLicenseRequest.ReadOnly {
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest
  ): io.github.vigoo.zioaws.licensemanager.model.GetLicenseRequest.ReadOnly =
    new Wrapper(impl)
}
