package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.TokenString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccessTokenResponse(
    accessToken: Option[TokenString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse = {
    import GetAccessTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse
      .builder()
      .optionallyWith(accessToken.map(value => value: java.lang.String))(
        _.accessToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse
      .wrap(buildAwsValue())
}
object GetAccessTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .GetAccessTokenResponse(accessTokenValue.map(value => value))
    def accessTokenValue: Option[TokenString]
    def accessToken: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("accessToken", accessTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly {
    override def accessTokenValue: Option[TokenString] =
      scala.Option(impl.accessToken()).map(value => value: TokenString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly =
    new Wrapper(impl)
}
