package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.TokenString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTokenResponse(
    tokenId: Option[String] = None,
    tokenType: Option[io.github.vigoo.zioaws.licensemanager.model.TokenType] =
      None,
    token: Option[TokenString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse = {
    import CreateTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse
      .builder()
      .optionallyWith(tokenId.map(value => value: java.lang.String))(_.tokenId)
      .optionallyWith(tokenType.map(value => value.unwrap))(_.tokenType)
      .optionallyWith(token.map(value => value: java.lang.String))(_.token)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse
      .wrap(buildAwsValue())
}
object CreateTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse =
      io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse(
        tokenIdValue.map(value => value),
        tokenTypeValue.map(value => value),
        tokenValue.map(value => value)
      )
    def tokenIdValue: Option[String]
    def tokenTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.TokenType]
    def tokenValue: Option[TokenString]
    def tokenId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tokenId", tokenIdValue)
    def tokenType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.TokenType
    ] = AwsError.unwrapOptionField("tokenType", tokenTypeValue)
    def token: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("token", tokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly {
    override def tokenIdValue: Option[String] =
      scala.Option(impl.tokenId()).map(value => value: String)
    override def tokenTypeValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.TokenType] = scala
      .Option(impl.tokenType())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.TokenType.wrap(value)
      )
    override def tokenValue: Option[TokenString] =
      scala.Option(impl.token()).map(value => value: TokenString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly =
    new Wrapper(impl)
}
