package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
sealed trait CheckoutType {
  def unwrap: software.amazon.awssdk.services.licensemanager.model.CheckoutType
}
object CheckoutType {
  def wrap(
      value: software.amazon.awssdk.services.licensemanager.model.CheckoutType
  ): io.github.vigoo.zioaws.licensemanager.model.CheckoutType = value match {
    case software.amazon.awssdk.services.licensemanager.model.CheckoutType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.CheckoutType.PROVISIONAL =>
      val r = PROVISIONAL
      r
    case software.amazon.awssdk.services.licensemanager.model.CheckoutType.PERPETUAL =>
      val r = PERPETUAL
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.licensemanager.model.CheckoutType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.CheckoutType =
      software.amazon.awssdk.services.licensemanager.model.CheckoutType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONAL
      extends io.github.vigoo.zioaws.licensemanager.model.CheckoutType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.CheckoutType =
      software.amazon.awssdk.services.licensemanager.model.CheckoutType.PROVISIONAL
  }
  case object PERPETUAL
      extends io.github.vigoo.zioaws.licensemanager.model.CheckoutType {
    override def unwrap
        : software.amazon.awssdk.services.licensemanager.model.CheckoutType =
      software.amazon.awssdk.services.licensemanager.model.CheckoutType.PERPETUAL
  }
}
