package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.ClientToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CheckoutLicenseRequest(
    productSKU: String,
    checkoutType: io.github.vigoo.zioaws.licensemanager.model.CheckoutType,
    keyFingerprint: String,
    entitlements: Iterable[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData
    ],
    clientToken: ClientToken,
    beneficiary: Option[String] = None,
    nodeId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest = {
    import CheckoutLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest
      .builder()
      .productSKU(productSKU: java.lang.String)
      .checkoutType(checkoutType.unwrap)
      .keyFingerprint(keyFingerprint: java.lang.String)
      .entitlements(entitlements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .clientToken(clientToken: java.lang.String)
      .optionallyWith(beneficiary.map(value => value: java.lang.String))(
        _.beneficiary
      )
      .optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseRequest
      .wrap(buildAwsValue())
}
object CheckoutLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseRequest =
      io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseRequest(
        productSKUValue,
        checkoutTypeValue,
        keyFingerprintValue,
        entitlementsValue.map { item =>
          item.editable
        },
        clientTokenValue,
        beneficiaryValue.map(value => value),
        nodeIdValue.map(value => value)
      )
    def productSKUValue: String
    def checkoutTypeValue
        : io.github.vigoo.zioaws.licensemanager.model.CheckoutType
    def keyFingerprintValue: String
    def entitlementsValue: List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ]
    def clientTokenValue: ClientToken
    def beneficiaryValue: Option[String]
    def nodeIdValue: Option[String]
    def productSKU: ZIO[Any, Nothing, String] = ZIO.succeed(productSKUValue)
    def checkoutType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.CheckoutType
    ] = ZIO.succeed(checkoutTypeValue)
    def keyFingerprint: ZIO[Any, Nothing, String] =
      ZIO.succeed(keyFingerprintValue)
    def entitlements: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ]] = ZIO.succeed(entitlementsValue)
    def clientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientTokenValue)
    def beneficiary: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("beneficiary", beneficiaryValue)
    def nodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeId", nodeIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseRequest.ReadOnly {
    override def productSKUValue: String = impl.productSKU(): String
    override def checkoutTypeValue
        : io.github.vigoo.zioaws.licensemanager.model.CheckoutType =
      io.github.vigoo.zioaws.licensemanager.model.CheckoutType
        .wrap(impl.checkoutType())
    override def keyFingerprintValue: String = impl.keyFingerprint(): String
    override def entitlementsValue: List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ] = impl
      .entitlements()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.licensemanager.model.EntitlementData.wrap(item)
      }
      .toList
    override def clientTokenValue: ClientToken = impl.clientToken(): ClientToken
    override def beneficiaryValue: Option[String] =
      scala.Option(impl.beneficiary()).map(value => value: String)
    override def nodeIdValue: Option[String] =
      scala.Option(impl.nodeId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseRequest.ReadOnly =
    new Wrapper(impl)
}
