package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  ISO8601DateTime,
  SignedToken,
  Arn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CheckoutBorrowLicenseResponse(
    licenseArn: Option[Arn] = None,
    licenseConsumptionToken: Option[String] = None,
    entitlementsAllowed: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.EntitlementData]
    ] = None,
    nodeId: Option[String] = None,
    signedToken: Option[SignedToken] = None,
    issuedAt: Option[ISO8601DateTime] = None,
    expiration: Option[ISO8601DateTime] = None,
    checkoutMetadata: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Metadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse = {
    import CheckoutBorrowLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse
      .builder()
      .optionallyWith(licenseArn.map(value => value: java.lang.String))(
        _.licenseArn
      )
      .optionallyWith(
        licenseConsumptionToken.map(value => value: java.lang.String)
      )(_.licenseConsumptionToken)
      .optionallyWith(
        entitlementsAllowed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitlementsAllowed)
      .optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId)
      .optionallyWith(signedToken.map(value => value: java.lang.String))(
        _.signedToken
      )
      .optionallyWith(issuedAt.map(value => value: java.lang.String))(
        _.issuedAt
      )
      .optionallyWith(expiration.map(value => value: java.lang.String))(
        _.expiration
      )
      .optionallyWith(
        checkoutMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.checkoutMetadata)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse
      .wrap(buildAwsValue())
}
object CheckoutBorrowLicenseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse =
      io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse(
        licenseArnValue.map(value => value),
        licenseConsumptionTokenValue.map(value => value),
        entitlementsAllowedValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nodeIdValue.map(value => value),
        signedTokenValue.map(value => value),
        issuedAtValue.map(value => value),
        expirationValue.map(value => value),
        checkoutMetadataValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def licenseArnValue: Option[Arn]
    def licenseConsumptionTokenValue: Option[String]
    def entitlementsAllowedValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly]
    ]
    def nodeIdValue: Option[String]
    def signedTokenValue: Option[SignedToken]
    def issuedAtValue: Option[ISO8601DateTime]
    def expirationValue: Option[ISO8601DateTime]
    def checkoutMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ]
    def licenseArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def licenseConsumptionToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "licenseConsumptionToken",
        licenseConsumptionTokenValue
      )
    def entitlementsAllowed: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "entitlementsAllowed",
      entitlementsAllowedValue
    )
    def nodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeId", nodeIdValue)
    def signedToken: ZIO[Any, AwsError, SignedToken] =
      AwsError.unwrapOptionField("signedToken", signedTokenValue)
    def issuedAt: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def expiration: ZIO[Any, AwsError, ISO8601DateTime] =
      AwsError.unwrapOptionField("expiration", expirationValue)
    def checkoutMetadata: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly
    ]] = AwsError.unwrapOptionField("checkoutMetadata", checkoutMetadataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly {
    override def licenseArnValue: Option[Arn] =
      scala.Option(impl.licenseArn()).map(value => value: Arn)
    override def licenseConsumptionTokenValue: Option[String] =
      scala.Option(impl.licenseConsumptionToken()).map(value => value: String)
    override def entitlementsAllowedValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.EntitlementData.ReadOnly]
    ] = scala
      .Option(impl.entitlementsAllowed())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.EntitlementData.wrap(item)
        }.toList
      )
    override def nodeIdValue: Option[String] =
      scala.Option(impl.nodeId()).map(value => value: String)
    override def signedTokenValue: Option[SignedToken] =
      scala.Option(impl.signedToken()).map(value => value: SignedToken)
    override def issuedAtValue: Option[ISO8601DateTime] =
      scala.Option(impl.issuedAt()).map(value => value: ISO8601DateTime)
    override def expirationValue: Option[ISO8601DateTime] =
      scala.Option(impl.expiration()).map(value => value: ISO8601DateTime)
    override def checkoutMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ] = scala
      .Option(impl.checkoutMetadata())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Metadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse
  ): io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly =
    new Wrapper(impl)
}
