package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UntagResourceRequest(resourceArn: String, tagKeys: Iterable[String]) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest.builder().resourceArn(resourceArn: java.lang.String).tagKeys(tagKeys.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: UntagResourceRequest.ReadOnly = UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UntagResourceRequest = UntagResourceRequest(resourceArnValue, tagKeysValue)
    def resourceArnValue: String
    def tagKeysValue: List[String]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def tagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest) extends UntagResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def tagKeysValue: List[String] = impl.tagKeys().asScala.map { item => 
      item: String
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest): ReadOnly = new Wrapper(impl)
}