package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReportGenerator(reportGeneratorName: scala.Option[String] = None, reportType: scala.Option[Iterable[ReportType]] = None, reportContext: scala.Option[ReportContext] = None, reportFrequency: scala.Option[ReportFrequency] = None, licenseManagerReportGeneratorArn: scala.Option[String] = None, lastRunStatus: scala.Option[String] = None, lastRunFailureReason: scala.Option[String] = None, lastReportGenerationTime: scala.Option[String] = None, reportCreatorAccount: scala.Option[String] = None, description: scala.Option[String] = None, s3Location: scala.Option[S3Location] = None, createTime: scala.Option[String] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ReportGenerator = {
    import ReportGenerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReportGenerator.builder().optionallyWith(reportGeneratorName.map(value => value: java.lang.String))(_.reportGeneratorName).optionallyWith(reportType.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.reportTypeWithStrings).optionallyWith(reportContext.map(value => value.buildAwsValue()))(_.reportContext).optionallyWith(reportFrequency.map(value => value.buildAwsValue()))(_.reportFrequency).optionallyWith(licenseManagerReportGeneratorArn.map(value => value: java.lang.String))(_.licenseManagerReportGeneratorArn).optionallyWith(lastRunStatus.map(value => value: java.lang.String))(_.lastRunStatus).optionallyWith(lastRunFailureReason.map(value => value: java.lang.String))(_.lastRunFailureReason).optionallyWith(lastReportGenerationTime.map(value => value: java.lang.String))(_.lastReportGenerationTime).optionallyWith(reportCreatorAccount.map(value => value: java.lang.String))(_.reportCreatorAccount).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(s3Location.map(value => value.buildAwsValue()))(_.s3Location).optionallyWith(createTime.map(value => value: java.lang.String))(_.createTime).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: ReportGenerator.ReadOnly = ReportGenerator.wrap(buildAwsValue())
}
object ReportGenerator {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ReportGenerator] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReportGenerator = ReportGenerator(reportGeneratorNameValue.map(value => value), reportTypeValue.map(value => value), reportContextValue.map(value => value.editable), reportFrequencyValue.map(value => value.editable), licenseManagerReportGeneratorArnValue.map(value => value), lastRunStatusValue.map(value => value), lastRunFailureReasonValue.map(value => value), lastReportGenerationTimeValue.map(value => value), reportCreatorAccountValue.map(value => value), descriptionValue.map(value => value), s3LocationValue.map(value => value.editable), createTimeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def reportGeneratorNameValue: scala.Option[String]
    def reportTypeValue: scala.Option[List[ReportType]]
    def reportContextValue: scala.Option[ReportContext.ReadOnly]
    def reportFrequencyValue: scala.Option[ReportFrequency.ReadOnly]
    def licenseManagerReportGeneratorArnValue: scala.Option[String]
    def lastRunStatusValue: scala.Option[String]
    def lastRunFailureReasonValue: scala.Option[String]
    def lastReportGenerationTimeValue: scala.Option[String]
    def reportCreatorAccountValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def s3LocationValue: scala.Option[S3Location.ReadOnly]
    def createTimeValue: scala.Option[String]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def reportGeneratorName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reportGeneratorName", reportGeneratorNameValue)
    def reportType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReportType]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reportType", reportTypeValue)
    def reportContext: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReportContext.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reportContext", reportContextValue)
    def reportFrequency: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReportFrequency.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reportFrequency", reportFrequencyValue)
    def licenseManagerReportGeneratorArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseManagerReportGeneratorArn", licenseManagerReportGeneratorArnValue)
    def lastRunStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastRunStatus", lastRunStatusValue)
    def lastRunFailureReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastRunFailureReason", lastRunFailureReasonValue)
    def lastReportGenerationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastReportGenerationTime", lastReportGenerationTimeValue)
    def reportCreatorAccount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reportCreatorAccount", reportCreatorAccountValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def s3Location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, S3Location.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3Location", s3LocationValue)
    def createTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createTime", createTimeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ReportGenerator) extends ReportGenerator.ReadOnly {
    override def reportGeneratorNameValue: scala.Option[String] = scala.Option(impl.reportGeneratorName()).map(value => value: String)
    override def reportTypeValue: scala.Option[List[ReportType]] = scala.Option(impl.reportType()).map(value => value.asScala.map { item => 
      ReportType.wrap(item)
    }.toList)
    override def reportContextValue: scala.Option[ReportContext.ReadOnly] = scala.Option(impl.reportContext()).map(value => ReportContext.wrap(value))
    override def reportFrequencyValue: scala.Option[ReportFrequency.ReadOnly] = scala.Option(impl.reportFrequency()).map(value => ReportFrequency.wrap(value))
    override def licenseManagerReportGeneratorArnValue: scala.Option[String] = scala.Option(impl.licenseManagerReportGeneratorArn()).map(value => value: String)
    override def lastRunStatusValue: scala.Option[String] = scala.Option(impl.lastRunStatus()).map(value => value: String)
    override def lastRunFailureReasonValue: scala.Option[String] = scala.Option(impl.lastRunFailureReason()).map(value => value: String)
    override def lastReportGenerationTimeValue: scala.Option[String] = scala.Option(impl.lastReportGenerationTime()).map(value => value: String)
    override def reportCreatorAccountValue: scala.Option[String] = scala.Option(impl.reportCreatorAccount()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def s3LocationValue: scala.Option[S3Location.ReadOnly] = scala.Option(impl.s3Location()).map(value => S3Location.wrap(value))
    override def createTimeValue: scala.Option[String] = scala.Option(impl.createTime()).map(value => value: String)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ReportGenerator): ReadOnly = new Wrapper(impl)
}