package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTokensResponse(tokens: scala.Option[Iterable[TokenData]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListTokensResponse = {
    import ListTokensResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListTokensResponse.builder().optionallyWith(tokens.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tokens).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListTokensResponse.ReadOnly = ListTokensResponse.wrap(buildAwsValue())
}
object ListTokensResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListTokensResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTokensResponse = ListTokensResponse(tokensValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def tokensValue: scala.Option[List[TokenData.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def tokens: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[TokenData.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokens", tokensValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListTokensResponse) extends ListTokensResponse.ReadOnly {
    override def tokensValue: scala.Option[List[TokenData.ReadOnly]] = scala.Option(impl.tokens()).map(value => value.asScala.map { item => 
      TokenData.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListTokensResponse): ReadOnly = new Wrapper(impl)
}