package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTagsForResourceRequest(resourceArn: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest.builder().resourceArn(resourceArn: java.lang.String).build()
  }
  def asReadOnly: ListTagsForResourceRequest.ReadOnly = ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTagsForResourceRequest = ListTagsForResourceRequest(resourceArnValue)
    def resourceArnValue: String
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest) extends ListTagsForResourceRequest.ReadOnly { override def resourceArnValue: String = impl.resourceArn(): String }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest): ReadOnly = new Wrapper(impl)
}