package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListResourceInventoryRequest(maxResults: scala.Option[primitives.BoxInteger] = None, nextToken: scala.Option[String] = None, filters: scala.Option[Iterable[InventoryFilter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest = {
    import ListResourceInventoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest.builder().optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).build()
  }
  def asReadOnly: ListResourceInventoryRequest.ReadOnly = ListResourceInventoryRequest.wrap(buildAwsValue())
}
object ListResourceInventoryRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListResourceInventoryRequest = ListResourceInventoryRequest(maxResultsValue.map(value => value), nextTokenValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }))
    def maxResultsValue: scala.Option[primitives.BoxInteger]
    def nextTokenValue: scala.Option[String]
    def filtersValue: scala.Option[List[InventoryFilter.ReadOnly]]
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InventoryFilter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest) extends ListResourceInventoryRequest.ReadOnly {
    override def maxResultsValue: scala.Option[primitives.BoxInteger] = scala.Option(impl.maxResults()).map(value => value: primitives.BoxInteger)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
    override def filtersValue: scala.Option[List[InventoryFilter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      InventoryFilter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest): ReadOnly = new Wrapper(impl)
}