package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListReceivedLicensesResponse(licenses: scala.Option[Iterable[GrantedLicense]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse = {
    import ListReceivedLicensesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse.builder().optionallyWith(licenses.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenses).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListReceivedLicensesResponse.ReadOnly = ListReceivedLicensesResponse.wrap(buildAwsValue())
}
object ListReceivedLicensesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListReceivedLicensesResponse = ListReceivedLicensesResponse(licensesValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def licensesValue: scala.Option[List[GrantedLicense.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def licenses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GrantedLicense.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenses", licensesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse) extends ListReceivedLicensesResponse.ReadOnly {
    override def licensesValue: scala.Option[List[GrantedLicense.ReadOnly]] = scala.Option(impl.licenses()).map(value => value.asScala.map { item => 
      GrantedLicense.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse): ReadOnly = new Wrapper(impl)
}