package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListLicenseSpecificationsForResourceRequest(resourceArn: String, maxResults: scala.Option[primitives.BoxInteger] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest = {
    import ListLicenseSpecificationsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest.builder().resourceArn(resourceArn: java.lang.String).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListLicenseSpecificationsForResourceRequest.ReadOnly = ListLicenseSpecificationsForResourceRequest.wrap(buildAwsValue())
}
object ListLicenseSpecificationsForResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListLicenseSpecificationsForResourceRequest = ListLicenseSpecificationsForResourceRequest(resourceArnValue, maxResultsValue.map(value => value), nextTokenValue.map(value => value))
    def resourceArnValue: String
    def maxResultsValue: scala.Option[primitives.BoxInteger]
    def nextTokenValue: scala.Option[String]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest) extends ListLicenseSpecificationsForResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def maxResultsValue: scala.Option[primitives.BoxInteger] = scala.Option(impl.maxResults()).map(value => value: primitives.BoxInteger)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest): ReadOnly = new Wrapper(impl)
}