package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListFailuresForLicenseConfigurationOperationsResponse(licenseOperationFailureList: scala.Option[Iterable[LicenseOperationFailure]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse = {
    import ListFailuresForLicenseConfigurationOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse.builder().optionallyWith(licenseOperationFailureList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseOperationFailureList).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListFailuresForLicenseConfigurationOperationsResponse.ReadOnly = ListFailuresForLicenseConfigurationOperationsResponse.wrap(buildAwsValue())
}
object ListFailuresForLicenseConfigurationOperationsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListFailuresForLicenseConfigurationOperationsResponse = ListFailuresForLicenseConfigurationOperationsResponse(licenseOperationFailureListValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def licenseOperationFailureListValue: scala.Option[List[LicenseOperationFailure.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def licenseOperationFailureList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LicenseOperationFailure.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseOperationFailureList", licenseOperationFailureListValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse) extends ListFailuresForLicenseConfigurationOperationsResponse.ReadOnly {
    override def licenseOperationFailureListValue: scala.Option[List[LicenseOperationFailure.ReadOnly]] = scala.Option(impl.licenseOperationFailureList()).map(value => value.asScala.map { item => 
      LicenseOperationFailure.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse): ReadOnly = new Wrapper(impl)
}