package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListDistributedGrantsRequest(grantArns: scala.Option[Iterable[primitives.Arn]] = None, filters: scala.Option[Iterable[Filter]] = None, nextToken: scala.Option[String] = None, maxResults: scala.Option[primitives.MaxSize100] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest = {
    import ListDistributedGrantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest.builder().optionallyWith(grantArns.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.grantArns).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListDistributedGrantsRequest.ReadOnly = ListDistributedGrantsRequest.wrap(buildAwsValue())
}
object ListDistributedGrantsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListDistributedGrantsRequest = ListDistributedGrantsRequest(grantArnsValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def grantArnsValue: scala.Option[List[primitives.Arn]]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def maxResultsValue: scala.Option[primitives.MaxSize100]
    def grantArns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Arn]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("grantArns", grantArnsValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxSize100] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest) extends ListDistributedGrantsRequest.ReadOnly {
    override def grantArnsValue: scala.Option[List[primitives.Arn]] = scala.Option(impl.grantArns()).map(value => value.asScala.map { item => 
      item: primitives.Arn
    }.toList)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: scala.Option[primitives.MaxSize100] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxSize100)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest): ReadOnly = new Wrapper(impl)
}