package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LicenseOperationFailure(resourceArn: scala.Option[String] = None, resourceType: scala.Option[ResourceType] = None, errorMessage: scala.Option[String] = None, failureTime: scala.Option[primitives.DateTime] = None, operationName: scala.Option[String] = None, resourceOwnerId: scala.Option[String] = None, operationRequestedBy: scala.Option[String] = None, metadataList: scala.Option[Iterable[Metadata]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure = {
    import LicenseOperationFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure.builder().optionallyWith(resourceArn.map(value => value: java.lang.String))(_.resourceArn).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(errorMessage.map(value => value: java.lang.String))(_.errorMessage).optionallyWith(failureTime.map(value => value: java.time.Instant))(_.failureTime).optionallyWith(operationName.map(value => value: java.lang.String))(_.operationName).optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(_.resourceOwnerId).optionallyWith(operationRequestedBy.map(value => value: java.lang.String))(_.operationRequestedBy).optionallyWith(metadataList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.metadataList).build()
  }
  def asReadOnly: LicenseOperationFailure.ReadOnly = LicenseOperationFailure.wrap(buildAwsValue())
}
object LicenseOperationFailure {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LicenseOperationFailure = LicenseOperationFailure(resourceArnValue.map(value => value), resourceTypeValue.map(value => value), errorMessageValue.map(value => value), failureTimeValue.map(value => value), operationNameValue.map(value => value), resourceOwnerIdValue.map(value => value), operationRequestedByValue.map(value => value), metadataListValue.map(value => value.map { item => 
      item.editable
    }))
    def resourceArnValue: scala.Option[String]
    def resourceTypeValue: scala.Option[ResourceType]
    def errorMessageValue: scala.Option[String]
    def failureTimeValue: scala.Option[primitives.DateTime]
    def operationNameValue: scala.Option[String]
    def resourceOwnerIdValue: scala.Option[String]
    def operationRequestedByValue: scala.Option[String]
    def metadataListValue: scala.Option[List[Metadata.ReadOnly]]
    def resourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def errorMessage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("errorMessage", errorMessageValue)
    def failureTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureTime", failureTimeValue)
    def operationName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operationName", operationNameValue)
    def resourceOwnerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerIdValue)
    def operationRequestedBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operationRequestedBy", operationRequestedByValue)
    def metadataList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Metadata.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metadataList", metadataListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure) extends LicenseOperationFailure.ReadOnly {
    override def resourceArnValue: scala.Option[String] = scala.Option(impl.resourceArn()).map(value => value: String)
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def errorMessageValue: scala.Option[String] = scala.Option(impl.errorMessage()).map(value => value: String)
    override def failureTimeValue: scala.Option[primitives.DateTime] = scala.Option(impl.failureTime()).map(value => value: primitives.DateTime)
    override def operationNameValue: scala.Option[String] = scala.Option(impl.operationName()).map(value => value: String)
    override def resourceOwnerIdValue: scala.Option[String] = scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override def operationRequestedByValue: scala.Option[String] = scala.Option(impl.operationRequestedBy()).map(value => value: String)
    override def metadataListValue: scala.Option[List[Metadata.ReadOnly]] = scala.Option(impl.metadataList()).map(value => value.asScala.map { item => 
      Metadata.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure): ReadOnly = new Wrapper(impl)
}