package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LicenseConfigurationStatus { def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus }
object LicenseConfigurationStatus {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus): LicenseConfigurationStatus = value match {
    case software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends LicenseConfigurationStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus = software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.UNKNOWN_TO_SDK_VERSION }
  case object AVAILABLE extends LicenseConfigurationStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus = software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.AVAILABLE }
  case object DISABLED extends LicenseConfigurationStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus = software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus.DISABLED }
}