package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLicenseResponse(license: scala.Option[License] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse = {
    import GetLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse.builder().optionallyWith(license.map(value => value.buildAwsValue()))(_.license).build()
  }
  def asReadOnly: GetLicenseResponse.ReadOnly = GetLicenseResponse.wrap(buildAwsValue())
}
object GetLicenseResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLicenseResponse = GetLicenseResponse(licenseValue.map(value => value.editable))
    def licenseValue: scala.Option[License.ReadOnly]
    def license: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, License.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("license", licenseValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse) extends GetLicenseResponse.ReadOnly { override def licenseValue: scala.Option[License.ReadOnly] = scala.Option(impl.license()).map(value => License.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse): ReadOnly = new Wrapper(impl)
}