package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLicenseManagerReportGeneratorResponse(reportGenerator: scala.Option[ReportGenerator] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse = {
    import GetLicenseManagerReportGeneratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse.builder().optionallyWith(reportGenerator.map(value => value.buildAwsValue()))(_.reportGenerator).build()
  }
  def asReadOnly: GetLicenseManagerReportGeneratorResponse.ReadOnly = GetLicenseManagerReportGeneratorResponse.wrap(buildAwsValue())
}
object GetLicenseManagerReportGeneratorResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLicenseManagerReportGeneratorResponse = GetLicenseManagerReportGeneratorResponse(reportGeneratorValue.map(value => value.editable))
    def reportGeneratorValue: scala.Option[ReportGenerator.ReadOnly]
    def reportGenerator: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReportGenerator.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reportGenerator", reportGeneratorValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse) extends GetLicenseManagerReportGeneratorResponse.ReadOnly { override def reportGeneratorValue: scala.Option[ReportGenerator.ReadOnly] = scala.Option(impl.reportGenerator()).map(value => ReportGenerator.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse): ReadOnly = new Wrapper(impl)
}