package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EntitlementUsage(name: String, consumedValue: String, maxCount: scala.Option[String] = None, unit: EntitlementDataUnit) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.EntitlementUsage = {
    import EntitlementUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.EntitlementUsage.builder().name(name: java.lang.String).consumedValue(consumedValue: java.lang.String).optionallyWith(maxCount.map(value => value: java.lang.String))(_.maxCount).unit(unit.unwrap).build()
  }
  def asReadOnly: EntitlementUsage.ReadOnly = EntitlementUsage.wrap(buildAwsValue())
}
object EntitlementUsage {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.EntitlementUsage] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EntitlementUsage = EntitlementUsage(nameValue, consumedValueValue, maxCountValue.map(value => value), unitValue)
    def nameValue: String
    def consumedValueValue: String
    def maxCountValue: scala.Option[String]
    def unitValue: EntitlementDataUnit
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def consumedValue: ZIO[Any, Nothing, String] = ZIO.succeed(consumedValueValue)
    def maxCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxCount", maxCountValue)
    def unit: ZIO[Any, Nothing, EntitlementDataUnit] = ZIO.succeed(unitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.EntitlementUsage) extends EntitlementUsage.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def consumedValueValue: String = impl.consumedValue(): String
    override def maxCountValue: scala.Option[String] = scala.Option(impl.maxCount()).map(value => value: String)
    override def unitValue: EntitlementDataUnit = EntitlementDataUnit.wrap(impl.unit())
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.EntitlementUsage): ReadOnly = new Wrapper(impl)
}