package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteLicenseResponse(status: scala.Option[LicenseDeletionStatus] = None, deletionDate: scala.Option[primitives.ISO8601DateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse = {
    import DeleteLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse.builder().optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(deletionDate.map(value => value: java.lang.String))(_.deletionDate).build()
  }
  def asReadOnly: DeleteLicenseResponse.ReadOnly = DeleteLicenseResponse.wrap(buildAwsValue())
}
object DeleteLicenseResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteLicenseResponse = DeleteLicenseResponse(statusValue.map(value => value), deletionDateValue.map(value => value))
    def statusValue: scala.Option[LicenseDeletionStatus]
    def deletionDateValue: scala.Option[primitives.ISO8601DateTime]
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LicenseDeletionStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def deletionDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionDate", deletionDateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse) extends DeleteLicenseResponse.ReadOnly {
    override def statusValue: scala.Option[LicenseDeletionStatus] = scala.Option(impl.status()).map(value => LicenseDeletionStatus.wrap(value))
    override def deletionDateValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.deletionDate()).map(value => value: primitives.ISO8601DateTime)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse): ReadOnly = new Wrapper(impl)
}